<?php
session_start();
include('conexion.php');

?>

<!doctype html>
<html lang="en" onclick="cerrar();cerrar2()">

<head>
  <?php
  include('./include/sesiones.php');
  include('./include/head.php');
  ?>
  <div id="div_buscador"></div>
  <?php
  include('./php_menu/menu_categorias.php');
  include('./php_menu/menu_izquierdo.php');
  ?>
</head>

<body>
  <section>
    <div class="shopping_cart_area mt-80">
      <div class="container">
        <div id="resultados"></div>
        <div id="tabla_cart"> </div>
      </div>
    </div>
  </section>
  <?php
  if (isset($_GET['modal']) == 'si') { ?>
    <input name="modal" type="hidden" id="modal" value="<?php echo $_GET['modal']; ?>" />
  <?php
  } 
   ?>
</body>


<?php include('include/footer.php'); ?>
<script src="assets/js/plugins.js"></script>
<script src="assets/js/main.js"></script>
<script type="text/javascript">
  function buscador() {
    $.get("./php_menu/buscador.php", "", function(data) {
      $("#div_buscador").html(data);
    })
  }
  buscador();



  function actualizarcantidad(art_id, cantidad) {
    $.ajax({
      type: "GET",
      url: "php_tienda/actualizar_cantidad.php",
      data: "art_id=" + art_id + "&cantidad=" + cantidad,
      beforeSend: function(objeto) {
        $('#resultados').html('');
      },
      success: function(datos) {
        $("#resultados").html(datos);
        buscador();
        loadcarrito();
      }
    });
  }


  function envia_deseos(art_id) {
    var parametros = {
      "art_id": art_id
    };
    $.ajax({
      data: parametros,
      url: './php_tienda/registrar_deseos.php',
      type: 'POST',
      beforeSend: function() {
        $('#resultados').html('');
      },
      success: function(datos) {
        $("#resultados").html(datos);
        loadcarrito();
        buscador();
      }
    });
  }



  function eliminar_articulo(id_art) {
    $.ajax({
      type: "GET",
      url: "php_tienda/eliminar_articulos.php",
      data: "id_art=" + id_art,
      beforeSend: function(objeto) {
        $('#resultados').html('');
      },
      success: function(datos) {
        $("#resultados").html(datos);
        loadcarrito();
        buscador();
      }
    });
  }




  function eliminar_deseo(art_id) {
    var parametros = {
      "art_id": art_id
    };
    $.ajax({
      data: parametros,
      url: './php_tienda/eliminar_deseo.php',
      type: 'POST',
      beforeSend: function() {
        $('#resultados').html('');
      },
      success: function(datos) {
        $("#resultados").html(datos);
        loadcarrito();
        buscador();
      }
    });
  }



  function loadcarrito() {
    var modal = $("#modal").val();
    $.get("./php_tienda/tabla_carrito.php?modal=" + modal, function(data) {
      $("#tabla_cart").html(data);
    })
  }
  loadcarrito();
  buscador();
</script>


</html>