<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS RESUMEN RETENCIONES')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'NUMERO FAC')
            ->setCellValue('B3', 'CLIENTE')
            ->setCellValue('C3', 'BASE')
            ->setCellValue('D3', '% RET')
            ->setCellValue('E3', 'VALOR RETENCION');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(5);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20);
$sheet->getColumnDimension('E')->setWidth(20); 


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$total_rets=0;
$query=mysqli_query($con, "SELECT * FROM ventas v , retencion_venta r where v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.sucursal='$sucursal' and v.empresa='$empresa' and v.ven_estado<>'anulada' and r.ventas_ven_id=v.ven_id order by v.ven_id desc");

  while ($roww=mysqli_fetch_array($query))    
{
    $ven_id=$roww['ven_id'];
    $sumador_combo=0;
    $sumador_total=0;

    $neto=0;
    $total_descuento=0;
    $total_iva=0;
    $total_retencion=0;
    $sumador_articulos=0;

    $ret=mysqli_query($con, "SELECT * FROM retencion_venta where ventas_ven_id='$ven_id' ") or die(mysqli_error($con)); 
    $rets=mysqli_fetch_array($ret);
    $ret_porcentaje=$rets['porcentaje'];

    $sql=mysqli_query($con, "SELECT * from venta_detalle where ventas_ven_id='$ven_id'");
    while ($row=mysqli_fetch_array($sql))
    {
        
        $vend_referencia=$row['vend_referencia'];
        $vend_nombre=$row['vend_nombre'];
        $vend_cantidad=$row['vend_cantidad'];
        $vend_precio=$row['vend_precio']; //1.000.000
        $vend_iva=$row['vend_iva']; //19%
        $vend_descuento=$row['vend_desc']; //10%

        $iva0=$vend_iva/100; //0.19
        $iva1=1+$iva0; //1.19

        $precio_total_item=$vend_precio*$vend_cantidad;//precio normal 1.000.000
        $precio_total_sin_iva_item=($vend_precio/$iva1)*$vend_cantidad; //precio sin iva  840.336
        $descuento_item=($vend_descuento/100)*$precio_total_sin_iva_item; //descuento_item 84.033
        $total_iva_item=$precio_total_sin_iva_item*$iva0; // total iva  159.336

        $neto+=$precio_total_sin_iva_item;
        $total_descuento+=$descuento_item;
        $total_iva+=$total_iva_item;

        $sumador_articulos=($neto+$total_iva)-$total_descuento;
        $sumador_articulos=($neto+$total_iva)-$total_descuento;

        $base=$neto;
        $total_retencion+=($neto+$sumador_combo-$total_descuento)*($ret_porcentaje/100);
        $sumador_total=$sumador_articulos+$sumador_combo-$total_retencion;
        $total_rets+=$total_retencion;

        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        
        // Agregar datos
        $sheet
        ->setCellValue($a, $roww['ven_prefijo'].'-'.$roww['ven_n_venta'])
        ->setCellValue($b, $roww['ven_nombre'])
        ->setCellValue($c, $base,0)
        ->setCellValue($d, $ret_porcentaje.' %')
        ->setCellValue($e, number_format($total_retencion));
        

        $cel+=1;
    }
   
}

        $d="D".$cel;
        $e="E".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":C".($cel))
        ->setCellValue($d, 'TOTAL GENERAL')
        ->setCellValue($e,  number_format($total_rets,0));

        cellColor('A'.$cel.':E'.$cel, 'BDBDBD');

        $cel+=1;
   


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE CIERRES DE CAJA.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>