<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$empleados=$_GET['empleados'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:G1')->mergeCells('A2:G2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:G2', 'BDBDBD'); 
cellColor('A1:G1', 'BDBDBD'); 
cellColor('A3:G3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS NOMINA')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'PERIODO PAGO')
            ->setCellValue('B3', 'SALARIO')
            ->setCellValue('C3', 'CESANTIAS.')
            ->setCellValue('D3', 'INT. SOBRE CESAN.')
            ->setCellValue('E3', 'PRI. SERVICIO')
            ->setCellValue('F3', 'VACACIONES')
            ->setCellValue('G3', 'DEDUCCIONES');

//Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(40);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);
$sheet->getColumnDimension('G')->setWidth(20);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$query=mysqli_query($con,"SELECT * FROM dian_nomina where nom_fecha  BETWEEN '$desde' and '$hastaf' and empresa='$empresa' and nom_estado='Aprobada' and nom_emp_id='$empleados'") or die(mysqli_error($con));

 $roww=mysqli_fetch_array($query);

    $nom_id=$roww['nom_id'];
    $nom_fecha_inicio=$roww['nom_fecha_inicio'];
    $nom_fecha_fin=$roww['nom_fecha_fin'];
    $nom_emp_id=$roww['nom_emp_id'];

    $datos=mysqli_query($con,"SELECT * FROM empleados WHERE emp_id='$nom_emp_id' and empresa='$empresa'") ;
    $fila=mysqli_fetch_array($datos);

    $emp_nombre=$fila['emp_nombre'];
    $emp_primer_apellido=$fila['emp_primer_apellido'];
    $emp_segundo_apellido=$fila['emp_segundo_apellido'];
    $emp_cc=$fila['emp_cc'];

 $total_salario=0;
$total_deducciones=0;
$total_vacaciones=0;
$total_cesantias=0;
$total_interes_cesantia=0;
$total_prima=0;


             $a="A".$cel;

             $sheet->mergeCells("A".($cel).":G".($cel))
             ->setCellValue($a, utf8_decode($emp_nombre.' '.$emp_primer_apellido.' '.$emp_segundo_apellido.'  '.'C.C  '.$emp_cc));
              cellColor('A'.$cel.':G'.$cel, 'BDBDBD');
             $cel+=1;

while ($roww=mysqli_fetch_array($query))    
{
   
    $nom_id=$roww['nom_id'];
    $nom_fecha_inicio=$roww['nom_fecha_inicio'];
    $nom_fecha_fin=$roww['nom_fecha_fin'];
    $nom_emp_id=$roww['nom_emp_id'];
    $nom_fecha=$roww['nom_fecha'];

   
    $datos1=mysqli_query($con,"SELECT * FROM dian_nomina_detalle WHERE  nomd_tipo='dev' and nomd_nombre_in='salary' and nom_id='$nom_id'") ;
        $fila1=mysqli_fetch_array($datos1);
        
        $salario=$fila1['nomd_precio'];

        $datos2=mysqli_query($con,"SELECT * FROM dian_nomina_detalle WHERE  nomd_tipo='dev' and nomd_nombre_in='transportation_allowance' and nom_id='$nom_id'") ;
        $fila2=mysqli_fetch_array($datos2);
        
        $auxilio=$fila2['nomd_precio'];
            

        $salario_total=$salario+$auxilio;

        $cesantias=$salario_total*0.0833;

        $interes_cesantia=$salario_total*0.01;

        $prima=$salario_total*0.0833;

        $vacaciones=$salario*0.0417;

   
        $datos3=mysqli_query($con,"SELECT * FROM dian_nomina_detalle WHERE  nomd_tipo='ded' and nomd_nombre_in='eps_deduction' and nom_id='$nom_id'") ;
            $fila3=mysqli_fetch_array($datos3);
            
            $eps=$fila3['nomd_precio'];

        $datos4=mysqli_query($con,"SELECT * FROM dian_nomina_detalle WHERE  nomd_tipo='ded' and nomd_nombre_in='eps_deduction' and nom_id='$nom_id'") ;
            $fila4=mysqli_fetch_array($datos4);
            
            $pension=$fila4['nomd_precio'];

            $deducciones=$pension+$eps;


        $total_salario+=$salario_total;
        $total_cesantias+=$cesantias;
        $total_interes_cesantia+=$interes_cesantia;
        $total_prima+=$prima;
        $total_vacaciones+=$vacaciones;
        $total_deducciones+=$deducciones;


    
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;

         $sheet->setCellValue($a, $nom_fecha_inicio.' - '.$nom_fecha_fin)
        ->setCellValue($b, number_format($salario_total,0))
        ->setCellValue($c, number_format($cesantias,0))
        ->setCellValue($d, number_format($interes_cesantia,0))
        ->setCellValue($e, number_format($prima,0))
        ->setCellValue($f, number_format($vacaciones,0))
        ->setCellValue($g, number_format($deducciones,0));


    $cel+=1;
}


        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;

         $sheet->setCellValue($a, 'TOTALES')
        ->setCellValue($b, number_format($total_salario,0))
        ->setCellValue($c, number_format($total_cesantias,0))
        ->setCellValue($d, number_format($total_interes_cesantia,0))
        ->setCellValue($e, number_format($total_prima,0))
        ->setCellValue($f, number_format($total_vacaciones,0))
        ->setCellValue($g, number_format($total_deducciones,0));

          cellColor('A'.$cel.':G'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS NOMINA.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>