<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:f1')->mergeCells('A2:f2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:f2', 'BDBDBD'); 
cellColor('A1:f1', 'BDBDBD'); 
cellColor('A3:f3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE PERDIDA Y GANANCIA DETALLADA')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'CODIGO')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'CANTIDAD')
            ->setCellValue('D3', 'PRECIO COSTO')
            ->setCellValue('E3', 'PRECIO VENTA')
            ->setCellValue('F3', 'UTILIDAD');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(30);  
$sheet->getColumnDimension('C')->setWidth(15); 
$sheet->getColumnDimension('D')->setWidth(15); 
$sheet->getColumnDimension('E')->setWidth(15);
$sheet->getColumnDimension('F')->setWidth(15);

    $cel=4;//Numero de fila donde empezara a crear  el reporte

$utt=0;
$pcc=0;
$pvv=0;

$uttc=0;
$pccc=0;
$pvvc=0;


$fecha1 = $desde;
$fecha2 = $hasta;

for($i=$fecha1;$i<=$fecha2;$i = date("Y-m-d", strtotime($i ."+ 1 days")))
{
    

    $registros=mysqli_query($con,"SELECT * FROM ventas where ven_fecha='$i' and sucursal='$sucursal'  and empresa='$empresa' and ven_estado<>'anulada' order by ven_n_venta desc") or die(mysqli_error($con));
    $numr=mysqli_num_rows($registros);
    if($numr>0)
    {
        
        $a="A".$cel;
                // Agregar datos
        $sheet->mergeCells("A".($cel).":F".($cel))
        ->setCellValue($a, $i);

        cellColor('A'.$cel.':F'.$cel, 'BDBDBD'); 


        $cel+=1;
    }
    
    while ($reg=mysqli_fetch_array($registros))
    {
        $ven_id=$reg['ven_id'];
        $sql=mysqli_query($con, "SELECT * from venta_detalle where ventas_ven_id='$ven_id' AND vend_art_id<>'5770' AND vend_art_id<>'5771'  and vend_art_id<>'8577'");
        while ($row=mysqli_fetch_array($sql))
        {
            $vend_art_id=$row['vend_art_id'];
            $vend_referencia=$row['vend_referencia'];
            $vend_nombre=$row['vend_nombre'];
            $vend_cantidad=$row['vend_cantidad_dev'];
            $vend_costo=$row['vend_costo'];
            $vend_precio_real=$row['vend_precio_real'];

            if ($vend_costo==null) {
                $art=mysqli_query($con, "SELECT * from articulos where art_id='$vend_art_id'");
                $row1=mysqli_fetch_array($art);
                if($row1==null)
                {
                    $art2=mysqli_query($con, "SELECT avg(comd_precio) as comd_precio, sum(comd_cantidad) comd_cantidad FROM `compra_detalle` WHERE comd_art_id='$vend_art_id'");
                    $row2=mysqli_fetch_array($art2);
                    $precio_costo=$row2['comd_precio'];

                }
                else
                {
                    $precio_costo=$row1['art_precio_costo'];
                }

            }
            else
            {
                $precio_costo=$vend_costo;
            }

            $costo=$precio_costo*$vend_cantidad;
            $venta=$vend_precio_real*$vend_cantidad;
            $utilidad=$venta-$costo;

            $pcc+=$costo;   
            $pvv+=$venta;
            $utt+=$utilidad;


            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
            $g="G".$cel;
            
           
            // Agregar datos
            $sheet
            ->setCellValue($a, $vend_referencia)
            ->setCellValue($b, $vend_nombre)
            ->setCellValue($c, $vend_cantidad)
            ->setCellValue($d, number_format($costo))
            ->setCellValue($e, number_format($venta))
            ->setCellValue($f, number_format($utilidad));
            
            

            $cel+=1;
            
        }   


        $sqlc=mysqli_query($con, "SELECT * from venta_detalle_combo where ven_id='$ven_id' ");
        while ($rowc=mysqli_fetch_array($sqlc))
        {
            $combo_id=$rowc['combo_id'];
            $combo_cantidad=$rowc['combo_cantidad'];
            $combo_nombre=$rowc['combo_nombre'];
            $combo_precio=$rowc['combo_precio'];
            $combo_desc=$rowc['combo_desc'];

            $totalprecio_costo=0;
            $com=mysqli_query($con, "SELECT * from combos_articulos where combos_com_id='$combo_id'");
            while ($com1=mysqli_fetch_array($com))
            {
                $coma_art_id=$com1['coma_art_id'];
                $coma_art_cantidad=$com1['coma_art_cantidad'];
                $artc=mysqli_query($con, "SELECT * from articulos where art_id='$coma_art_id'");
                $row1=mysqli_fetch_array($artc);
                $totalprecio_costo+=$precio_costo=$row1['art_precio_costo']*$coma_art_cantidad;
            }       

            $costo_combo=$totalprecio_costo*$combo_cantidad;
            $venta_combo=$combo_precio*$combo_cantidad;
            $utilidad_combo=$venta_combo-$costo_combo;

            $pccc+=$costo_combo;   
            $pvvc+=$venta_combo;
            $uttc+=$utilidad_combo;

            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
            
          
           
            // Agregar datos
            $sheet
            ->setCellValue($a, '')
            ->setCellValue($b, $combo_nombre)
            ->setCellValue($c, $combo_cantidad)
            ->setCellValue($d, number_format($costo_combo))
            ->setCellValue($e, number_format($venta_combo))
            ->setCellValue($f, number_format($utilidad_combo));
            
            
            
            $cel+=1;
        }      
    }
}          
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
           
             // Agregar datos
            $sheet->mergeCells("A".($cel).":B".($cel))
            ->setCellValue($c, "TOTAL")
            ->setCellValue($d, number_format($pcc+$pccc,0))
            ->setCellValue($e, number_format($pvv+$pvvc,0))
            ->setCellValue($f, number_format($utt+$uttc,0));

          cellColor('C'.$cel.':F'.$cel, 'BDBDBD'); 
          
            
            $cel+=1;

            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
           
             // Agregar datos
            $sheet->mergeCells("A".($cel).":B".($cel))
            ->setCellValue($c, "TOTAL COMBO")
            ->setCellValue($d, number_format($pccc,0))
            ->setCellValue($e, number_format($pvvc,0))
            ->setCellValue($f, number_format($uttc,0));

          cellColor('C'.$cel.':F'.$cel, 'BDBDBD'); 
          
            
            $cel+=1;


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE PERDIDA Y GANANCIA DETALLADA.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>