<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$art_id=$_GET['art_id'];


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:f1')->mergeCells('A2:f2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:f2', 'BDBDBD'); 
cellColor('A1:f1', 'BDBDBD'); 
cellColor('A3:f3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE UTILIDAD POR ARTICULO')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'CODIGO')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'CANTIDAD')
            ->setCellValue('D3', 'PRECIO COSTO')
            ->setCellValue('E3', 'PRECIO VENTA')
            ->setCellValue('F3', 'UTILIDAD');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte


$tot_costo=0;
$tot_venta=0;
$tot_utilidad=0;
$tot_can=0;

$registros=mysqli_query($con,"SELECT *, sum(d.vend_cantidad_dev) as can, AVG(d.vend_costo) as pc, AVG(d.vend_precio_real) as pv from ventas v ,venta_detalle d WHERE v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.sucursal='$sucursal' and v.empresa='$empresa' and d.vend_art_id='$art_id' and d.ventas_ven_id=v.ven_id group by d.vend_art_id order by can desc") or die(mysqli_error($con));


while ($row=mysqli_fetch_array($registros))
{
    $vend_art_id=$row['vend_art_id'];
    $costo=$row['can']*$row['pc'];
    $venta=$row['can']*$row['pv'];
    $can=$row['can'];
    $uti=$venta-$costo;
    $tot_costo+=$costo;
    $tot_venta+=$venta; 
    $tot_utilidad+=$uti;
    $tot_can+=$can;

    $sql1=mysqli_query($con, "SELECT * from articulos where art_id='$vend_art_id' and empresa='$empresa' ");
    $cos=mysqli_fetch_array($sql1);

    $art_referencia=$cos['art_referencia'];
    $art_nombre=$cos['art_nombre'];


 
            $a="A".$cel;
            $b="B".$cel;
            $c="C".$cel;
            $d="D".$cel;
            $e="E".$cel;
            $f="F".$cel;
           
            // Agregar datos
            $sheet
            ->setCellValue($a, $art_referencia)
            ->setCellValue($b, $art_nombre)
            ->setCellValue($c, $can)
            ->setCellValue($d, number_format($costo,0))
            ->setCellValue($e, number_format($venta,0))
            ->setCellValue($f, number_format($uti,0));
                        
          
    $cel+=1;

    }
           

// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE UTILIDAD POR ARTICULO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>