<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:L1')->mergeCells('A2:L2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:L2', 'BDBDBD'); 
cellColor('A1:L1', 'BDBDBD'); 
cellColor('A3:L3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE CIERRES DE CAJA')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'N')
            ->setCellValue('B3', 'FECHA')
            ->setCellValue('C3', 'USUARIO')
            ->setCellValue('D3', 'BASE')
            ->setCellValue('E3', 'VENTAS')
            ->setCellValue('F3', 'CREDITO')
            ->setCellValue('G3', 'TARJETA')
            ->setCellValue('H3', 'TRANFERENCIA')
            ->setCellValue('I3', 'ABONOS')
            ->setCellValue('J3', 'EGRESOS')
            ->setCellValue('K3', 'CIERRE')
            ->setCellValue('L3', 'DIFERENCIA');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(5);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);
$sheet->getColumnDimension('G')->setWidth(20);
$sheet->getColumnDimension('H')->setWidth(20);
$sheet->getColumnDimension('I')->setWidth(20);
$sheet->getColumnDimension('J')->setWidth(20);
$sheet->getColumnDimension('K')->setWidth(20);
$sheet->getColumnDimension('L')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$empleadoo=$_GET['empleadoo'];
$sumador_total=0; 
$query=mysqli_query($con, "SELECT * FROM movimiento_caja where mca_usuario='$empleadoo' and ( mca_inicio >='$desde' AND mca_final<='$hastaf') and sucursal='$sucursal' and empresa='$empresa' order by mca_id asc");

  while ($reg=mysqli_fetch_array($query))    
{
    $mca_usuario=$reg['mca_usuario']; 
    $apertura=$reg['apertura'];
    $mca_final=$reg['mca_final'];
    $datos1=mysqli_query($con,"SELECT * FROM usuario WHERE usu_id='$mca_usuario'");
    $fila1=mysqli_fetch_array( $datos1 );
    $usu_nombre=$fila1['usu_nombre'];

    $mca_base=number_format($reg['mca_base'],0);
    $mca_ventas=number_format($reg['mca_ventas'],0); 
    $mca_credito=number_format($reg['mca_credito'],0);
    $mca_tarjeta=number_format($reg['mca_tarjeta'],0);
    $mca_transferencia=number_format($reg['mca_transferencia'],0);
    $mca_abonos=number_format($reg['mca_abonos'],0); 
    $mca_otros_movimientos=number_format($reg['mca_otros_movimientos'],0);
    $mca_valor_cierre=number_format($reg['mca_valor_cierre'],0); 
    $mca_diferencia=number_format($reg['mca_diferencia'],0);

    $sumador_total+=$reg['mca_valor_cierre']; 

    
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
        $i="I".$cel;
        $j="J".$cel;
        $k="K".$cel;
        $l="L".$cel;

         $sheet->setCellValue($a, $apertura)
        ->setCellValue($b, $mca_final)
        ->setCellValue($c, $usu_nombre)
        ->setCellValue($d, $mca_base)
        ->setCellValue($e, $mca_ventas)
        ->setCellValue($f, $mca_credito)
        ->setCellValue($g, $mca_tarjeta)
        ->setCellValue($h, $mca_transferencia)
        ->setCellValue($i, $mca_abonos)
        ->setCellValue($j, $mca_otros_movimientos)
        ->setCellValue($k, $mca_valor_cierre)
        ->setCellValue($l, $mca_diferencia);

    $cel+=1;
}

        $j="J".$cel;
        $k="K".$cel;
        $l="L".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":I".($cel))
        ->setCellValue($j, 'TOTAL GENERAL')
        ->setCellValue($k,  number_format($sumador_total,0))
        ->setCellValue($l,  '');

          cellColor('A'.$cel.':L'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE CIERRES DE CAJA.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>