<?php
session_start();
require '../../conexion.php';
require_once('../../include/sesiones.php');

$desde = $_GET['fecha_desde'];
$hasta = $_GET['fecha_hasta'];
$vendedores = implode("','", $_GET["vendedor4"]);
$sucursal_form = $_GET['sucursal_form'];

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=resumen_articulos_" . date("Ymd_His") . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "<style>
    body { font-family: Arial, sans-serif; }
    table { border-collapse: collapse; width: 100%; }
    th, td { border: 1px solid #999; padding: 5px; font-size: 12px; }
    th { background-color: #f2f2f2; }
</style>";

echo "<table border='1'>";
echo "<tr><th colspan='4'>RESUMEN DE ARTICULOS DESDE $desde HASTA $hasta</th></tr>";
echo "<tr style='background:#d7ebf5'>
        <th>REF</th>
        <th>NOMBRE</th>
        <th>CANTIDAD</th>
        <th>UM</th>
      </tr>";

$query_str = "SELECT * FROM venta_detalle d
    JOIN ventas v ON d.ventas_ven_id = v.ven_id
    JOIN articulos a ON a.art_id = d.vend_art_id
WHERE 
    v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$desde' AND '$hasta'
    AND v.sucursal = '$sucursal_form'
    AND v.empresa = '$empresa'
    AND vendedor IN ('$vendedores')";

if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo11"]);
    $query_str .= " AND ven_tipo IN ('$ven_tipo')";
}
$query_str .= " ORDER BY d.vend_nombre ASC";
$sql_art = mysqli_query($con, $query_str);

$agrupado = [];
while ($row = mysqli_fetch_array($sql_art)) {
    $clave = $row['vend_art_id'] . '|' . $row['vend_unidad'];
    if (!isset($agrupado[$clave])) {
        $agrupado[$clave] = [
            'vend_referencia' => $row['vend_referencia'],
            'vend_nombre' => $row['vend_nombre'],
            'vend_unidad' => $row['vend_unidad'],
            'cantidad_total' => 0,
            'total_valor' => 0
        ];
    }

    $precio_con_desc = $row['vend_precio'] * (1 - $row['vend_desc'] / 100);
    $subtotal = $precio_con_desc * $row['vend_cantidad'];
    $agrupado[$clave]['cantidad_total'] += $row['vend_cantidad'] * $row['vend_x_cantidad'];
    $agrupado[$clave]['total_valor'] += $subtotal;
}

foreach ($agrupado as $art) {
    echo "<tr>
        <td>{$art['vend_referencia']}</td>
        <td>" . htmlspecialchars($art['vend_nombre']) . "</td>
        <td>" . number_format($art['cantidad_total'], 2) . "</td>
        <td>{$art['vend_unidad']}</td>
    </tr>";
}

// ==== COMBOS ====
$sqlc = "SELECT * FROM venta_detalle_combo d
    INNER JOIN ventas v ON d.ven_id = v.ven_id
    INNER JOIN combos c ON d.combo_id = c.com_id
    WHERE v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$desde' AND '$hasta'
    AND v.sucursal = '$sucursal_form'
    AND v.empresa = '$empresa'
    AND vendedor IN ('$vendedores')";

if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo11"]);
    $sqlc .= " AND ven_tipo IN ('$ven_tipo')";
}
$sqlc .= " ORDER BY d.combo_nombre ASC";
$sql_com = mysqli_query($con, $sqlc);

$agrupado_combos = [];

while ($row = mysqli_fetch_array($sql_com)) {
    $id = $row['combo_id'];
    if (!isset($agrupado_combos[$id])) {
        $agrupado_combos[$id] = [
            'combo_referencia' => $row['combo_referencia'],
            'combo_nombre' => $row['combo_nombre'],
            'unidad' => 'COMB',
            'cantidad_total' => 0,
            'total_valor' => 0,
        ];
    }

    $descuento = $row['combo_precio'] * ($row['combo_desc'] / 100);
    $precio_real = $row['combo_precio'] - $descuento;
    $total = $precio_real * $row['combo_cantidad'];

    $agrupado_combos[$id]['cantidad_total'] += $row['combo_cantidad'];
    $agrupado_combos[$id]['total_valor'] += $total;
}

foreach ($agrupado_combos as $combo) {
    echo "<tr>
        <td>{$combo['combo_referencia']}</td>
        <td>" . htmlspecialchars($combo['combo_nombre']) . "</td>
        <td>" . number_format($combo['cantidad_total'], 2) . "</td>
        <td>{$combo['unidad']}</td>
    </tr>";
}

echo "</table>";
?>
